import dns from "node:dns/promises";
function isValidEmail(e){return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(e)}
async function txtHas(d,p){try{const tx=await dns.resolveTxt(d);const flat=tx.map(a=>a.join("")).join(" ");return new RegExp("\\\\b"+p,"i").test(flat)}catch{return false}}
export default async function checkEmail(email){
  if(!isValidEmail(email)) return { email, valid:false, error:"invalid_format" };
  const domain=email.split("@")[1].toLowerCase();
  let hasMX=false, hasA=false, spf=false, dmarc=false;
  try{const mx=await dns.resolveMx(domain); hasMX=Array.isArray(mx)&&mx.length>0}catch{}
  try{await dns.resolve4(domain); hasA=true}catch{}
  spf=await txtHas(domain,"v=spf1");
  dmarc=await txtHas("_dmarc."+domain,"v=DMARC1");
  const deliverability=(hasMX||hasA)&&spf&&dmarc?"good":(hasMX||hasA)?"risky":"bad";
  const notes=[]; if(!hasMX&&!hasA)notes.push("no MX/A records"); if(!spf)notes.push("SPF missing"); if(!dmarc)notes.push("DMARC missing");
  return { email, domain, hasMX, hasA, spf, dmarc, deliverability, notes };
}
if (import.meta.url === "file://"+process.argv[1]){
  const email=process.argv[2]||""; checkEmail(email).then(r=>console.log(JSON.stringify(r,null,2)));
}
