import fs from "node:fs";
import readline from "node:readline";
import checkEmail from "./dns_email_check.mjs";
const input=process.argv[2];
if(!input||!fs.existsSync(input)){console.error("Usage: node bulk_check_csv.mjs <input.csv>");process.exit(1)}
function splitCSV(l){return l.split(",").map(s=>s.trim())}
const rl=readline.createInterface({input:fs.createReadStream(input,{encoding:"utf8"}),crlfDelay:Infinity});
let header=[],emailIdx=-1,first=true;
console.log("email,domain,hasMX,hasA,spf,dmarc,deliverability,notes");
for await (const raw of rl){
  const line=raw.trim(); if(!line) continue;
  if(first){
    header=splitCSV(line); emailIdx=header.findIndex(h=>h.toLowerCase()==="email");
    if(emailIdx===-1){console.error("CSV must contain \"email\" header");process.exit(1)}
    first=false; continue;
  }
  const cols=splitCSV(line); const email=(cols[emailIdx]||"").toLowerCase();
  const res=await checkEmail(email);
  const notes=(res.notes||[]).join(";").replace(/,/g,";");
  console.log([res.email||email,res.domain||"",res.hasMX?1:0,res.hasA?1:0,res.spf?1:0,res.dmarc?1:0,res.deliverability||"unknown",notes].join(","));
}
